import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:intl/intl.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/home/home_search.dart';
import 'package:nbt_app/screen/notification/notification_page.dart';

class CatchupPage extends StatefulWidget {
  const CatchupPage({Key? key}) : super(key: key);

  @override
  State<CatchupPage> createState() => _CatchupPageState();
}

class _CatchupPageState extends State<CatchupPage> {
  DateTime? _dateTime;
  DateFormat format = DateFormat('dd-MM-yyyy');
  TimeOfDay? time;
  String? pick;
  Future _showTimePicker() async {
    time = await showTimePicker(context: context, initialTime: TimeOfDay.now());
    if (time != null) {
      setState(() {
        pick = time!.format(context);
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        resizeToAvoidBottomInset: false,
        appBar: AppBar(
          elevation: 0.55,
          shadowColor: Color.fromRGBO(77, 32, 126, 1),
          bottomOpacity: 0,
          backgroundColor: Color.fromRGBO(77, 32, 126, 1),
          toolbarHeight: 80.h,
          title: Row(mainAxisAlignment: MainAxisAlignment.start, children: [
            Container(
                margin: EdgeInsets.only(top: 10),
                child: GestureDetector(
                    onTap: () {
                      Navigator.pop(context);
                    },
                    child: Icon(Icons.arrow_back_ios))),
            SizedBox(
              width: 110,
            ),
            Center(
              child: Text('Catch up',
                  style: TextStyle(
                      fontFamily: 'DBHeavent',
                      fontSize: 38,
                      color: Colors.white)),
            ),
            SizedBox(
              width: 81,
            ),
            GestureDetector(
              onTap: () {
                setState(() {
                  Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()));
                });
              },
              child: Icon(Icons.notifications_none),
            ),
            SizedBox(
              width: 10.w,
            ),
            GestureDetector(
                onTap: () {
                  Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => const HomeSearchPage()));
                },
                child: Icon(Icons.search)),
          ]),
        ),
        body: Container(
          width: MediaQuery.of(context).size.width,
          height: MediaQuery.of(context).size.height,
          child: Stack(
            children: [
              Container(
                color: Color.fromRGBO(77, 32, 126, 1),
                height: 60.h,
              ),
              Container(
                padding: EdgeInsets.only(top: 20, left: 25, right: 25),
                margin: EdgeInsets.only(left: 15, right: 15, bottom: 40),
                width: 400.h,
                height: 1000.h,
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.circular(10),
                  boxShadow: [
                    BoxShadow(
                        color: Colors.black.withOpacity(0.1),
                        spreadRadius: 3,
                        blurRadius: 6)
                  ],
                ),
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        children: [
                          Column(
                            children: [
                              Container(
                                width: 160,
                                child: Text(
                                  'เลือกตามปฎิทิน',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent',
                                    fontSize: 21,
                                    color: Color.fromRGBO(77, 37, 124, 1),
                                  ),
                                ),
                              ),
                              Container(
                                width: 160,
                                height: 40,
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(25.0),
                                  border:
                                      Border.all(color: Colors.grey.shade200),
                                ),
                                child: TextButton(
                                  onPressed: () {
                                    showDatePicker(
                                            context: context,
                                            initialDate: new DateTime.now(),
                                            firstDate: new DateTime(
                                                DateTime.now().year - 10),
                                            lastDate: new DateTime(
                                                DateTime.now().year + 10))
                                        .then((date) {
                                      setState(() {
                                        _dateTime = date;
                                      });
                                    });
                                  },
                                  child: Padding(
                                    padding: EdgeInsets.only(left: 5, right: 5),
                                    child: Row(
                                      children: [
                                        Text(
                                          _dateTime == null
                                              ? 'เลือกตามปฏิทิน'
                                              : format
                                                  .format(_dateTime!)
                                                  .toString(),
                                          style: TextStyle(
                                              fontFamily: 'DBHeavent',
                                              fontSize: 21,
                                              color: Colors.black
                                                  .withOpacity(0.6)),
                                        ),
                                        Expanded(child: SizedBox()),
                                        Icon(
                                          Icons.calendar_today_outlined,
                                          size: 21.0,
                                          color: Color.fromRGBO(77, 32, 126, 1),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                          SizedBox(
                            width: 11,
                          ),
                          Column(
                            children: [
                              Container(
                                width: 160,
                                child: Text(
                                  'เลือกตามเวลา',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent',
                                    fontSize: 21,
                                    color: Color.fromRGBO(77, 37, 124, 1),
                                  ),
                                ),
                              ),
                              Container(
                                width: 160,
                                height: 40,
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(25.0),
                                  border:
                                      Border.all(color: Colors.grey.shade200),
                                ),
                                child: TextButton(
                                  onPressed: () {
                                    _showTimePicker();
                                  },
                                  child: Padding(
                                    padding: EdgeInsets.only(left: 5, right: 5),
                                    child: Row(
                                      children: [
                                        Text(
                                          pick == null ? 'เลือกตามเวลา' : pick!,
                                          style: TextStyle(
                                              fontFamily: 'DBHeavent',
                                              fontSize: 21,
                                              color: Colors.black
                                                  .withOpacity(0.6)),
                                        ),
                                        Expanded(child: SizedBox()),
                                        Icon(
                                          Icons.access_time,
                                          size: 21.0,
                                          color: Color.fromRGBO(77, 32, 126, 1),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ],
                      ),
                      SizedBox(
                        height: 30,
                      ),
                      buildButton(),
                      SizedBox(
                        height: 30,
                      ),
                      Container(
                        height: MediaQuery.of(context).size.height,
                        child: ListView.separated(
                            scrollDirection: Axis.vertical,
                            itemCount: cardItems.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  height: 20,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardImage(item: cardItems[index]);
                            }),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}

buildDateTime(String topic, IconData icon, BuildContext context) {
  return Column(
    children: [
      Container(
        width: 160,
        child: Text(
          topic,
          style: TextStyle(
            fontFamily: 'DBHeavent',
            fontSize: 21,
            color: Color.fromRGBO(77, 37, 124, 1),
          ),
        ),
      ),
      SizedBox(
        height: 1,
      ),
      Container(
        width: 160,
        height: 40,
        child: TextField(
          autofocus: false,
          autocorrect: false,
          obscureText: false,
          decoration: InputDecoration(
              suffixIcon: GestureDetector(
                onTap: () {
                  showDatePicker(
                          context: context,
                          initialDate: DateTime.now(),
                          firstDate: DateTime(DateTime.now().year - 5),
                          lastDate: DateTime(DateTime.now().year + 5))
                      .then((value) {});
                },
                child: Icon(
                  icon,
                  size: 22,
                  color: Color.fromRGBO(77, 37, 124, 1),
                ),
              ),
              border: OutlineInputBorder(
                borderRadius: BorderRadius.circular(30),
              ),
              filled: true,
              contentPadding: EdgeInsets.only(
                left: 15,
              ),
              focusedBorder: OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey.shade200),
                borderRadius: BorderRadius.circular(30),
              ),
              enabledBorder: OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey.shade200),
                borderRadius: BorderRadius.circular(30),
              ),
              hintStyle: TextStyle(
                color: Colors.grey,
                fontFamily: 'DBHeavent',
                fontSize: 22,
              ),
              hintText: topic,
              fillColor: Colors.white),
        ),
      ),
    ],
  );
}

buildButton() {
  return Container(
    height: 50.h,
    width: 1000.h,
    decoration: BoxDecoration(
        gradient: LinearGradient(colors: [
          Color.fromRGBO(122, 79, 159, 1),
          Color.fromRGBO(77, 32, 126, 1)
        ], begin: Alignment.topCenter, end: Alignment.bottomCenter),
        color: Color.fromRGBO(77, 37, 124, 1),
        borderRadius: BorderRadius.circular(30)),
    child: Center(
      child: Text(
        'ค้นหา',
        style: TextStyle(
          fontFamily: 'DBHeavent',
          fontSize: 25,
          color: Colors.white,
        ),
      ),
    ),
  );
}

Widget buildCardImage({required CardItem item}) => Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
            height: 200,
            width: 330,
            child: ClipRRect(
                borderRadius: BorderRadius.circular(10),
                child: Image.network(
                  item.url,
                  fit: BoxFit.cover,
                ))),
        Container(
          margin: EdgeInsets.only(top: 5),
          child: Row(
            children: [
              Text(
                item.date,
                style: TextStyle(color: Colors.grey.shade500, fontSize: 15),
              ),
              SizedBox(
                width: 5,
              ),
              Icon(
                Icons.remove_red_eye,
                size: 15,
                color: Colors.grey.shade500,
              ),
              SizedBox(
                width: 5,
              ),
              Text(
                item.view,
                style: TextStyle(
                  color: Colors.grey,
                  // color: Color.fromRGBO(77, 32, 126, 1),
                  fontFamily: 'DBHeavent',
                  fontSize: 20,
                  fontWeight: FontWeight.w500,
                  letterSpacing: 1,
                ),
              ),
            ],
          ),
        ),
        Container(
          // width: 180,
          child: Text(
            item.title,
            softWrap: false,
            style: TextStyle(
                color: Colors.black,
                // color: Color.fromRGBO(77, 32, 126, 1),
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w700,
                letterSpacing: 1,
                height: 0.9),
          ),
        ),
      ],
    );
